package subscriptions

import (
	"net/url"
	"path"

	"a.yandex-team.ru/travel/notifier/internal/models"
)

type UnsubscribeLinkGenerator struct {
	unsubscribePath string
	travelPortalURL string
}

func NewUnsubscribeLinkGenerator(travelPortalURL, unsubscribePath string) *UnsubscribeLinkGenerator {
	return &UnsubscribeLinkGenerator{travelPortalURL: travelPortalURL, unsubscribePath: unsubscribePath}
}

func (u UnsubscribeLinkGenerator) Generate(recipient models.Recipient) string {
	parsed, _ := url.Parse(u.travelPortalURL)
	parsed.Path = path.Join(parsed.Path, u.unsubscribePath, *recipient.UnsubscribeHash)
	return parsed.String()
}
