package structs

type AudioGuidesForCity struct {
	DirectURL string       `json:"direct_url"`
	Tours     []AudioGuide `json:"tours"`
}

type AudioGuide struct {
	Name     string `json:"name"`
	ImageURL string `json:"image_url"`
	TourURL  string `json:"tour_url"`
	Type     string `json:"type"`
	Category string `json:"category"`
	Duration int    `json:"duration"`
}

func NewAudioGuidesForCity() AudioGuidesForCity {
	return AudioGuidesForCity{
		Tours: make([]AudioGuide, 0),
	}
}
