package structs

type WeatherForCity struct {
	CurrentTime          int64             `json:"now"`
	CurrentTimeFormatted string            `json:"now_dt"`
	Info                 *WeatherInfo      `json:"info"`
	Factual              *WeatherFactual   `json:"fact"`
	Forecasts            []WeatherForecast `json:"forecasts"`
}

type WeatherInfo struct {
	URL   string `json:"url"`
	GeoID int    `json:"geoid"`
}

type WeatherFactual struct {
	Temp            int     `json:"temp"`
	FeelsLike       int     `json:"feels_like"`
	Icon            string  `json:"icon"`
	Condition       string  `json:"condition"`
	WindSpeed       float64 `json:"wind_speed"`
	WindDir         string  `json:"wind_dir"`
	PressureMM      int     `json:"pressure_mm"`
	PressurePA      int     `json:"pressure_pa"`
	Humidity        int     `json:"humidity"`
	DaytimeCode     string  `json:"daytime"`
	IsPolar         bool    `json:"polar"`
	Season          string  `json:"string"`
	Cloudness       float64 `json:"cloudness"`
	ObservationTime int64   `json:"obs_time"`
	PhenomIcon      string  `json:"phenom_icon"`
	PhenomCondition string  `json:"phenom_condition"`
}

type WeatherForecast struct {
	Date       string                    `json:"date"`
	Timestamp  int64                     `json:"date_ts"`
	WeekNumber int                       `json:"week"`
	Sunrise    string                    `json:"sunrise"`
	Sunset     string                    `json:"sunset"`
	MoonCode   int                       `json:"moon_code"`
	MoonText   string                    `json:"moon_text"`
	DayParts   map[string]WeatherDayPart `json:"parts"`
}

type WeatherDayPart struct {
	TempMin               int     `json:"temp_min"`
	TempMax               int     `json:"temp_max"`
	TempAvg               int     `json:"temp_avg"`
	FeelsLike             int     `json:"feels_like"`
	Icon                  string  `json:"icon"`
	Condition             string  `json:"condition"`
	Daytime               string  `json:"daytime"`
	IsPolar               bool    `json:"polar"`
	WindSpeed             float64 `json:"wind_speed"`
	WindGust              float64 `json:"wind_gust"`
	WindDir               string  `json:"wind_dir"`
	PressureMM            int     `json:"pressure_mm"`
	PressurePA            int     `json:"pressure_pa"`
	Humidity              int     `json:"humidity"`
	PrecipitationMM       float64 `json:"prec_mm"`
	PrecipitationPeriod   int     `json:"prec_period"`
	PrecipitationType     int     `json:"prec_type"`
	PrecipitationStrength float64 `json:"prec_strength"`
	Cloudness             float64 `json:"cloudness"`
}

func NewWeatherForCity() WeatherForCity {
	return WeatherForCity{
		Forecasts: make([]WeatherForecast, 0),
	}
}
