package travelapi

import (
	"strings"
)

type (
	AdditionalOrderInfoResponse struct {
		Payload AdditionalOrderInfo `json:"payload"`
	}

	AdditionalOrderInfo struct {
		OrderID  string `json:"order_id"`
		PrettyID string `json:"pretty_id"`

		HotelOrderInfos []HotelOrderInfo `json:"hotel_order_infos"`
		TrainOrderInfos []TrainOrderInfo `json:"train_order_infos"`
	}

	HotelOrderInfo struct {
		Name    string `json:"name"`
		Address string `json:"address"`
		Phone   string `json:"phone"`

		CheckInBeginTime string `json:"check_in_begin_time"`
		CheckInEndTime   string `json:"check_in_end_time"`
		CheckOutTime     string `json:"check_out_time"`
		DocumentURL      string `json:"document_url"`
		ImageURLTemplate string `json:"image_url_template"`

		CheckInDate  string `json:"check_in_date"`
		CheckOutDate string `json:"check_out_date"`
	}

	TrainOrderInfo struct {
		StationFromID             string   `json:"station_from_id"`
		StationToID               string   `json:"station_to_id"`
		TrainStartSettlementTitle string   `json:"train_start_settlement_title"`
		TrainEndSettlementTitle   string   `json:"train_end_settlement_title"`
		Departure                 string   `json:"departure"`
		Arrival                   string   `json:"arrival"`
		TrainNumber               string   `json:"train_number"`
		BrandTitle                string   `json:"brand_title"`
		CarNumber                 string   `json:"car_number"`
		CarType                   string   `json:"car_type"`
		CompartmentGender         string   `json:"compartment_gender"`
		PlaceNumbers              []string `json:"place_numbers"`
	}
)

func (t TrainOrderInfo) GetCarNumber() string {
	return strings.TrimPrefix(t.CarNumber, "0")
}
