package travelapi

import (
	"context"
	"encoding/json"
	"errors"

	"a.yandex-team.ru/travel/notifier/internal/externalhttp"
	"a.yandex-team.ru/travel/notifier/internal/service/pretrip/blocks"
)

type AdditionalOrderInfoClient struct {
	httpClient *externalhttp.HTTPClient
}

func NewAdditionalOrderInfoClient(httpClient *externalhttp.HTTPClient) *AdditionalOrderInfoClient {
	return &AdditionalOrderInfoClient{
		httpClient: httpClient,
	}
}

func (c *AdditionalOrderInfoClient) GetAdditionalOrderInfo(ctx context.Context, orderID string) (*AdditionalOrderInfo, error) {
	result := AdditionalOrderInfoResponse{}
	params := map[string]string{"order_id": orderID}
	jsonBytes, err := c.httpClient.GetJSON(ctx, params)
	if err != nil {
		if errors.As(err, &externalhttp.TravelAPINotFoundError{}) {
			return nil, blocks.ErrDataNotFoundСritical
		}
		return nil, err
	}
	if err = json.Unmarshal(jsonBytes, &result); err != nil {
		return nil, err
	}
	return &result.Payload, nil
}
