package base

import (
	"context"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/library/go/errutil"
	"a.yandex-team.ru/yt/go/ypath"
	"a.yandex-team.ru/yt/go/yt"
)

func ReadTable(ctx context.Context, ytClient yt.Client, path ypath.Path, rowAdder RowAdder) (err error) {
	defer errutil.Wrap(&err, "ReadTable(path=%s)", path)
	reader, err := ytClient.ReadTable(ctx, path, nil)
	if err != nil {
		return err
	}
	defer func() {
		if err := reader.Close(); err != nil {
			log.Error(err)
		}
	}()
	for reader.Next() {
		if err := rowAdder.AddRow(reader); err != nil {
			return err
		}
		select {
		case <-ctx.Done():
			return ctx.Err()
		default:
		}
	}
	return nil
}
