package ytdicts

import (
	"context"
	"sort"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/travel/hotels/proto/data_config/promo"
	"a.yandex-team.ru/travel/library/go/errutil"
	"a.yandex-team.ru/travel/notifier/internal/ytdicts/base"
	"a.yandex-team.ru/travel/notifier/internal/ytdicts/mixin"
)

type PromoEventsRepository struct {
	mixin.ReadyReporter
	events []*promo.TPromoEvent
}

func (r *PromoEventsRepository) GetAll() ([]*promo.TPromoEvent, error) {
	if !r.Ready() {
		return nil, xerrors.Errorf("promo events repository is not ready")
	}
	return r.events, nil
}

func NewPromoEventsRepository() *PromoEventsRepository {
	return &PromoEventsRepository{
		events: nil,
	}
}

func (r *PromoEventsRepository) AddRow(scanner base.YtTableRowScanner) (err error) {
	defer errutil.Wrap(&err, "PromoEventsRepository.AddRow")
	event := &promo.TPromoEvent{}
	err = scanner.Scan(event)
	if err != nil {
		return err
	}
	r.events = append(r.events, event)
	return nil
}

func (r *PromoEventsRepository) UpdateFromSource(ctx context.Context, updater base.RepositoryUpdater) (err error) {
	defer errutil.Wrap(&err, "PromoEventsRepository.UpdateFromSource")
	newState := NewPromoEventsRepository()
	if err := updater.Populate(ctx, newState); err != nil {
		return err
	}
	newState.sort()
	*r = *newState
	r.SetReady()
	return nil
}

func (r *PromoEventsRepository) sort() {
	sort.SliceStable(
		r.events,
		func(i, j int) bool {
			return *r.events[i].EventId < *r.events[j].EventId ||
				(*r.events[i].EventId == *r.events[j].EventId && *r.events[i].OrdersCampaignId < *r.events[j].OrdersCampaignId)
		},
	)
}
