package ytdictconfig

import (
	"time"

	"a.yandex-team.ru/yt/go/ypath"
)

const DefaultUpdateInterval = 30 * time.Minute
const DefaultReadTimeout = time.Minute

type ServiceConfig struct {
	Enabled        bool          `yaml:"enabled"`
	UpdateInterval time.Duration `yaml:"update_interval"`
	Proxies        []string      `yaml:"proxies"`
	Token          string        `config:"YT_TOKEN" yaml:"token"`
	TablePath      ypath.Path    `yaml:"table_path"`
	ReadTimeout    time.Duration `yaml:"read_timeout"`
}

func (sc *ServiceConfig) GetUpdateInterval() time.Duration {
	if sc.UpdateInterval > 0 {
		return sc.UpdateInterval
	}
	return DefaultUpdateInterval
}

func (sc *ServiceConfig) GetReadTimeout() time.Duration {
	if sc.ReadTimeout > 0 {
		return sc.ReadTimeout
	}
	return DefaultReadTimeout
}
