package ytlock

import (
	"context"

	"a.yandex-team.ru/yt/go/ytlock"
)

type YtLock struct {
	ytLock    *ytlock.Lock
	onAcquire func()
	onRelease func()
}

type Option func(lock *YtLock)

func WithOnAcquire(onAcquire func()) Option {
	return func(lock *YtLock) {
		lock.onAcquire = onAcquire
	}
}

func WithOnRelease(onRelease func()) Option {
	return func(lock *YtLock) {
		lock.onRelease = onRelease
	}
}

func NewYtLock(ytLock *ytlock.Lock, opts ...Option) *YtLock {
	lock := &YtLock{ytLock: ytLock, onAcquire: func() {}, onRelease: func() {}}
	for _, opt := range opts {
		opt(lock)
	}
	return lock
}

func (l *YtLock) Acquire(ctx context.Context) error {
	lost, err := l.ytLock.Acquire(ctx)
	if err == nil {
		l.onAcquire()
		go func() {
			<-lost
			l.onRelease()
		}()
	}
	return err
}

func (l *YtLock) Release(ctx context.Context) error {
	return l.ytLock.Release(ctx)
}
