const CSP_SELF = 'self';
const CSP_UNSAFE_INLINE = 'unsafe-inline';
const CSP_UNSAFE_EVAL = 'unsafe-eval';
const CSP_DATA = 'data:';
const CSP_BLOB = 'blob:';

export default {
    authPolicy: 'optional',
    socket: 'dist/run/server.sock',
    csp: {
        'default-src': [CSP_SELF, CSP_BLOB],
        'script-src': [CSP_SELF, CSP_UNSAFE_INLINE, CSP_UNSAFE_EVAL],
        'style-src': [CSP_SELF, CSP_UNSAFE_INLINE, CSP_UNSAFE_EVAL],
        'img-src': [CSP_SELF, CSP_DATA],
        'connect-src': [
            CSP_SELF,
            // magic-links (startrek)
            'wf.yandex-team.ru',
        ],
        'frame-src': [CSP_SELF, CSP_BLOB],
        'frame-ancestors': [CSP_SELF],
        'font-src': [CSP_SELF],
    },
};
