import {Request, Response} from 'express';

import {Environment, ETheme} from '../../shared/types';

export default (req: Request, res: Response) => {
    const env = req.utils.config.env;

    // Тут надо сделать не optional: https://github.yandex-team.ru/data-ui/ui-core-layout/blob/master/src/types.ts#L110
    return res.send(
        res.renderLayout2!({
            // eslint-disable-line @typescript-eslint/no-non-null-assertion
            name: 'app',
            title: 'Яндекс.Путешествия - Заказы',
            data: {
                env,
            },
            nonce: req.nonce,
            icon: {
                type: 'image/x-icon',
                sizes: '16x16',
                href: `/favicon-${
                    env === Environment.production ? 'prod' : 'test'
                }.ico`,
            },
            bodyClassName: `yc-root_theme_${
                req.cookies.theme === ETheme.DARK ? ETheme.DARK : ETheme.LIGHT
            }`,
        }),
    );
};
