import logRequest from './logRequest';

export default function handleError(req: any, res: any, err: any) {
    const status = (err.response && err.response.status) || 500;

    res.status(status).send(
        (err.response && err.response.data) || {
            status,
            error: 'Internal error',
            message: err.message,
            stack: err.stack,
        },
    );

    logRequest(req, res);
}
