import apiLogger from '../../utils/apiLogger';

const moment = require('moment');
const dns = require('dns');
const os = require('os');

let selfIp = '';

dns.lookup(os.hostname(), (err: any, ip: any) => {
    selfIp = ip;
});

export default function logRequest(req: any, res: any) {
    apiLogger.log({
        src_ip: req.headers['x-real-ip'],
        user: req.blackbox.login,
        time: moment().format('D/MMM/YYYY:HH:mm:ss ZZ'),
        vhost: req.get('host'),
        dest_ip: selfIp,
        request: `${req.method} ${req.originalUrl} HTTP/${req.httpVersion}`,
        status: res.statusCode,
        http_referrer: req.get('Referrer'),
        http_user_agent: req.get('User-Agent'),
        yandexuid: req.cookies.yandexuid,
        byte: res.getHeader('content-length'),
    });
}
