'use strict';

import axios from 'axios';
import {Agent} from 'https';

import logRequest from './helpers/logRequest';
import handleError from './helpers/handleError';
import getCommonHeaders from './helpers/getCommonHeaders';

export default async function (req: any, res: any): Promise<void> {
    const {ordersApi} = req.utils.config;

    const {id: orderId} = req.params;
    const {needToFetchPersonalData} = req.query;

    if (
        !/^[a-z0-9-]*$/.test(orderId) ||
        !/^(true|false)$/.test(needToFetchPersonalData)
    ) {
        return handleError(req, res, new Error('Invalid params.'));
    }

    try {
        const {data: order} = await axios.get(
            `${ordersApi}/api/admin/v1/get_order`,
            {
                params: {
                    id: orderId,
                    snippets:
                        needToFetchPersonalData === 'true'
                            ? 'S_PRIVATE_INFO'
                            : '',
                },
                headers: getCommonHeaders(req),
                httpsAgent: new Agent({
                    rejectUnauthorized: false,
                }),
            },
        );

        res.send({order});

        logRequest(req, res);
    } catch (err) {
        handleError(req, res, err);
    }
}
