'use strict';

import axios from 'axios';
import {Agent} from 'https';

import logRequest from './helpers/logRequest';
import handleError from './helpers/handleError';
import getCommonHeaders from './helpers/getCommonHeaders';

export default async function (req: any, res: any): Promise<void> {
    const {
        page = '0',
        count = '30',
        level = '',
        logger = '',
        message = '',
    } = req.query;

    if (
        !/^\d+$/.test(page) ||
        !/^\d+$/.test(count) ||
        !/^[A-Z]*$/.test(level) ||
        !/^[a-zA-Z0-9-_.]*$/.test(logger)
    ) {
        return handleError(req, res, new Error('Invalid params.'));
    }

    const {ordersApi} = req.utils.config;

    try {
        const {data: dataData} = await axios.get(
            `${ordersApi}/api/admin/v1/get_order_logs`,
            {
                params: {
                    id: req.params.id,
                    offset: page * count,
                    limit: count,
                    level,
                    logger,
                    searchText: message,
                },
                headers: getCommonHeaders(req),
                httpsAgent: new Agent({
                    rejectUnauthorized: false,
                }),
            },
        );

        res.send(dataData);

        logRequest(req, res);
    } catch (err) {
        handleError(req, res, err);
    }
}
