'use strict';

import axios from 'axios';
import {Agent} from 'https';

import logRequest from './helpers/logRequest';
import handleError from './helpers/handleError';
import getCommonHeaders from './helpers/getCommonHeaders';

export default async function (req: any, res: any): Promise<void> {
    const {id: orderId} = req.params;

    const {
        adminActionToken,
        generateFinEvents,
        refundUserMoney,
        refundAmount,
        newInvoiceAmount,
        reason,
    } = req.body;

    if (!/^[a-z0-9-]*$/.test(orderId)) {
        return handleError(req, res, new Error('Invalid params.'));
    }

    const {ordersApi} = req.utils.config;

    try {
        const config = {
            headers: getCommonHeaders(req),
            httpsAgent: new Agent({
                rejectUnauthorized: false,
            }),
        };

        const {data} = await axios.post(
            `${ordersApi}/api/admin/v1/refund_hotel_money_only`,
            {
                admin_action_token: adminActionToken,
                order_id: orderId,
                generate_fin_events: generateFinEvents,
                refund_user_money: refundUserMoney,
                refund_amount: refundAmount,
                new_invoice_amount: newInvoiceAmount,
                reason,
            },
            config,
        );

        res.send(data);

        logRequest(req, res);
    } catch (err) {
        handleError(req, res, err);
    }
}
