'use strict';

import axios from 'axios';
import {Agent} from 'https';

import logRequest from './helpers/logRequest';
import handleError from './helpers/handleError';
import getCommonHeaders from './helpers/getCommonHeaders';

export default async function (req: any, res: any): Promise<void> {
    const {id: orderId} = req.params;

    if (!/^[a-z0-9-]*$/.test(orderId)) {
        return handleError(req, res, new Error('Invalid params.'));
    }

    const {ordersApi} = req.utils.config;

    try {
        const {data: dataData} = await axios.post(
            `${ordersApi}/api/admin/v1/regenerate_vouchers`,
            {
                order_id: orderId,
            },
            {
                headers: getCommonHeaders(req),
                httpsAgent: new Agent({
                    rejectUnauthorized: false,
                }),
            },
        );

        res.send(dataData);

        logRequest(req, res);
    } catch (err) {
        handleError(req, res, err);
    }
}
