'use strict';

import axios from 'axios';
import {Agent} from 'https';

import logRequest from './helpers/logRequest';
import handleError from './helpers/handleError';
import getCommonHeaders from './helpers/getCommonHeaders';

export default async function (req: any, res: any): Promise<void> {
    const {id: orderId} = req.params;

    const {transport, orderRefundId, type} = req.body;

    if (
        !/^[a-z0-9-]*$/.test(orderId) ||
        !/^[a-z0-9-]*$/.test(orderRefundId) ||
        !/^[A-Z_]*$/.test(transport) ||
        !/^[A-Z_]*$/.test(type)
    ) {
        return handleError(req, res, new Error('Invalid params.'));
    }

    const {ordersApi} = req.utils.config;

    try {
        const {data: dataData} = await axios.post(
            `${ordersApi}/api/admin/v1/send_user_notification`,
            {
                order_id: orderId,
                order_refund_id: orderRefundId,
                transport,
                type,
            },
            {
                headers: getCommonHeaders(req),
                httpsAgent: new Agent({
                    rejectUnauthorized: false,
                }),
            },
        );

        res.send(dataData);

        logRequest(req, res);
    } catch (err) {
        handleError(req, res, err);
    }
}
