'use strict';

import axios from 'axios';
import {Agent} from 'https';

import logRequest from './helpers/logRequest';
import handleError from './helpers/handleError';
import getCommonHeaders from './helpers/getCommonHeaders';

export default async function (req: any, res: any): Promise<void> {
    const workflowId = req.params.id;

    if (!/^[a-z0-9-]*$/.test(workflowId)) {
        return handleError(req, res, new Error('Invalid params.'));
    }

    const {ordersApi} = req.utils.config;

    try {
        const {data: dataData} = await axios.get(
            `${ordersApi}/api/admin/v1/get_workflow`,
            {
                params: {
                    id: req.params.id,
                },
                headers: getCommonHeaders(req),
                httpsAgent: new Agent({
                    rejectUnauthorized: false,
                }),
            },
        );

        res.send(dataData);

        logRequest(req, res);
    } catch (err) {
        handleError(req, res, err);
    }
}
