import Core from '@yandex-data-ui/core';
import {createMiddleware} from '@yandex-data-ui/ui-core-layout';
import sourceMaps from 'source-map-support';

import {MiddlewareStage} from '@yandex-data-ui/core/build/types';

import userInfoMiddleware from './middlewares/userInfoMiddleware';

import './utils/rotateApiLogs';

const app = new Core({name: 'travel-admin'});

if (app.devMode) {
    sourceMaps.install();
}

app.setupHealthcheck({
    path: '/ping',
    handler: (req, res) => {
        res.status(200).send({status: 'It is fine'});
    },
});

app.registerMiddleware({
    name: 'userInfoMiddleware',
    fn: userInfoMiddleware,
});

app.useMiddleware({
    stage: MiddlewareStage.AfterAuth,
    fn: createMiddleware(),
});

if (require.main === module) {
    app.run();
}

export default app;
export const utils = app.utils;
