export default (req: any, res: any, next: any) => {
    const {blackbox} = req;

    if (!blackbox.login) {
        return res.redirect(
            302,
            `https://passport.yandex-team.ru/passport?mode=auth&retpath=https://${
                req.hostname
            }${encodeURIComponent(req.originalUrl)}`,
        );
    }

    req.userInfo = {
        login: blackbox.login,
    };

    next();
};
