export default {
    'GET /api/orders/:id/logs': {
        target: 'orderLogs',
        afterAuth: ['userInfoMiddleware'],
    },
    'GET /api/orders/:id/updateTrainTicketsStatus': {
        target: 'updateTrainTicketsStatus',
        afterAuth: ['userInfoMiddleware'],
    },
    'GET /api/orders/:id/payloads': {
        target: 'getOrderPayloads',
        afterAuth: ['userInfoMiddleware'],
    },
    'GET /api/orders/:id/downloadBlank/:blank_id': {
        target: 'downloadBlank',
        afterAuth: ['userInfoMiddleware'],
    },
    'POST /api/orders/:id/payloads/:orderItemId': {
        target: 'editOrderPayload',
        afterAuth: ['userInfoMiddleware'],
    },
    'POST /api/orders/:id/email': {
        target: 'editOrderEmail',
        afterAuth: ['userInfoMiddleware'],
    },
    'POST /api/orders/:id/phone': {
        target: 'editOrderPhone',
        afterAuth: ['userInfoMiddleware'],
    },
    'POST /api/orders/:id/sendNotification': {
        target: 'sendNotification',
        afterAuth: ['userInfoMiddleware'],
    },
    'POST /api/orders/:id/retryMoneyRefund': {
        target: 'retryMoneyRefund',
        afterAuth: ['userInfoMiddleware'],
    },
    'POST /api/orders/:id/refund': {
        target: 'refund',
        afterAuth: ['userInfoMiddleware'],
    },
    'POST /api/orders/:id/restoreDolphinOrder': {
        target: 'restoreDolphinOrder',
        afterAuth: ['userInfoMiddleware'],
    },
    'POST /api/orders/:id/regenerateVouchers': {
        target: 'regenerateVouchers',
        afterAuth: ['userInfoMiddleware'],
    },
    'POST /api/orders/:id/refundHotelOrder': {
        target: 'refundHotelOrder',
        afterAuth: ['userInfoMiddleware'],
    },
    'GET /api/orders/:id/calculateHotelOrderRefund': {
        target: 'calculateHotelOrderRefund',
        afterAuth: ['userInfoMiddleware'],
    },
    'GET /api/orders/:id/calculateHotelMoneyOnlyRefund': {
        target: 'calculateHotelMoneyOnlyRefund',
        afterAuth: ['userInfoMiddleware'],
    },
    'POST /api/orders/:id/refundHotelMoneyOnly': {
        target: 'refundHotelMoneyOnly',
        afterAuth: ['userInfoMiddleware'],
    },
    'POST /api/orders/:id/modifyHotelOrderDetails': {
        target: 'modifyHotelOrderDetails',
        afterAuth: ['userInfoMiddleware'],
    },
    'GET /api/orders/:id': {
        target: 'order',
        afterAuth: ['userInfoMiddleware'],
    },
    'GET /api/orders': {
        target: 'orders',
        afterAuth: ['userInfoMiddleware'],
    },
    'GET /api/workflow/:id': {
        target: 'workflow',
        afterAuth: ['userInfoMiddleware'],
    },
    'GET *': {
        target: 'application',
        afterAuth: ['userInfoMiddleware'],
    },
};
