const fs = require('fs');

const apiLogger = {
    log(message: any) {
        const logFile = fs.createWriteStream('/ephemeral/var/log/api.log', {
            flags: 'a+',
        });

        try {
            logFile.write(JSON.stringify(message) + '\n');
        } catch (err) {
            console.error(err);
        }
    },
};

export default apiLogger;
