import React, {useMemo} from 'react';
import {useSelector} from 'react-redux';
import {Route, Switch, useLocation} from 'react-router-dom';
import {ThemeProvider} from '@yandex-data-ui/common';
import Cookies from 'js-cookie';
import {block} from 'bem-cn';

import {IStore} from 'redux/reducers/types';
import {ETheme} from 'shared/types';

import Breadcrumbs from 'components/basic/Breadcrumbs/Breadcrumbs';
import OrderRoutes from 'components/Order/OrderRoutes/OrderRoutes';
import Orders from 'components/Orders/Orders';
import Footer from 'components/Footer/Footer';
import NotFound from 'components/NotFound/NotFound';
import ErrorBoundary from 'components/basic/ErrorBoundary';
import LegoThemeProvider from 'components/lego/ThemeProvider/ThemeProvider';

import './index.scss';

const b = block('App');

const App: React.FC = () => {
    const {userInfo, env} = useSelector((state: IStore) => state);

    const {pathname} = useLocation();

    const initialTheme = useMemo(
        () => Cookies.get('theme') || ETheme.LIGHT,
        [],
    );

    const errorBlock = useMemo(() => {
        return (
            <h1 className={b('centerMainMessage')}>
                На странице что-то сломалось
            </h1>
        );
    }, []);

    const contentBlock = useMemo(() => {
        if (!/^[a-z0-9-/]*$/.test(pathname)) {
            return <NotFound />;
        }

        if (!userInfo.hasAccess) {
            return <h1 className={b('centerMainMessage')}>Получите доступ</h1>;
        }

        return (
            <>
                <div className={b('header')}>
                    <Breadcrumbs />
                </div>

                <div className={b('content')}>
                    <Switch>
                        <Route path="/:id" component={OrderRoutes} />
                        <Route exact path="/" component={Orders} />
                        <Route component={NotFound} />
                    </Switch>
                </div>

                <Footer className={b('footer')} />
            </>
        );
    }, []);

    return (
        <ThemeProvider theme={initialTheme}>
            <ErrorBoundary errorBlock={errorBlock}>
                <div className={b({env})}>
                    <LegoThemeProvider theme={initialTheme} />
                    {contentBlock}
                </div>
            </ErrorBoundary>
        </ThemeProvider>
    );
};

export default App;
