import React from 'react';
import {block} from 'bem-cn';

import Settings from 'components/Footer/Settings/Settings';

import './index.scss';

interface IFooterProps {
    className?: string;
}

const b = block('Footer');

const Footer: React.FC<IFooterProps> = props => {
    const {className} = props;

    return (
        <div className={b.mix(className)}>
            <div>
                Конфиденциально. Коммерческая тайна ООО &quot;Яндекс&quot;
            </div>

            <Settings className={b('settings')} />
        </div>
    );
};

export default Footer;
