import React, {useCallback, useEffect} from 'react';
import {useDispatch, useSelector} from 'react-redux';
import {useTheme} from '@yandex-data-ui/common';
import {CheckBox} from 'lego-on-react';
import Cookies from 'js-cookie';
import {block} from 'bem-cn';
import {setIsSettingsTechTexts} from 'redux/reducers/settings/actions';

import {IStore} from 'redux/reducers/types';
import {ETheme} from 'shared/types';

import './index.scss';

interface ISettingsProps {
    className?: string;
}

const b = block('Settings');

const Settings: React.FC<ISettingsProps> = props => {
    const {className} = props;

    const dispatch = useDispatch();

    const [theme, setTheme] = useTheme();

    const {isTechTexts} = useSelector((state: IStore) => state.settings);

    useEffect(() => {
        localStorage.setItem(
            'travelOrdersAdmin.settings.isTechTexts',
            JSON.stringify(isTechTexts),
        );
    }, [isTechTexts]);

    const handleTechTextChange = useCallback(() => {
        dispatch(setIsSettingsTechTexts(!isTechTexts));
    }, [dispatch, isTechTexts]);

    const handleThemeChange = useCallback(() => {
        const newTheme = theme === ETheme.DARK ? ETheme.LIGHT : ETheme.DARK;

        setTheme(newTheme);

        Cookies.set('theme', newTheme, {expires: 365});
    }, [setTheme, theme]);

    return (
        <div className={b.mix(className)}>
            <CheckBox
                cls={b('theme')}
                theme="normal"
                size="m"
                view="default"
                tone="default"
                checked={theme === ETheme.DARK}
                onChange={handleThemeChange}
            >
                Тёмная тема
            </CheckBox>

            <CheckBox
                theme="normal"
                size="m"
                view="default"
                tone="default"
                checked={isTechTexts}
                onChange={handleTechTextChange}
            >
                Технические названия
            </CheckBox>
        </div>
    );
};

export default Settings;
