import React, {useMemo} from 'react';
import {block} from 'bem-cn';

import {IHotelOrderCancellationInfo} from 'redux/reducers/types/hotel';

import HotelCancellationInfoPenalty from 'components/Order/HotelCancellationInfo/HotelCancellationInfoPenalty/HotelCancellationInfoPenalty';

interface IOwnProps {
    cancellationInfo: IHotelOrderCancellationInfo;
}

const b = block('HotelCancellationInfo');

const HotelCancellationInfo: React.FC<IOwnProps> = props => {
    const {cancellationInfo} = props;

    const content = useMemo(() => {
        if (!cancellationInfo.refundable) {
            return <div>Нельзя вернуть</div>;
        }

        return cancellationInfo.penalties.map((penalty, index) => (
            <HotelCancellationInfoPenalty penalty={penalty} key={index} />
        ));
    }, [cancellationInfo]);

    return <div className={b()}>{content}</div>;
};

export default HotelCancellationInfo;
