import React, {useMemo} from 'react';
import {block} from 'bem-cn';

import {
    IHotelOrderCancellationPenaltyItem,
    IHotelPenaltyTypes,
} from 'redux/reducers/types/hotel';

import getHumanMoscowFormat from 'lib/time/getHumanMoscowFormat';

interface IOwnProps {
    penalty: IHotelOrderCancellationPenaltyItem;
}

const b = block('HotelCancellationInfoPenalty');

const HotelCancellationInfoPenalty: React.FC<IOwnProps> = props => {
    const {
        penalty: {type, starts_at, ends_at, amount, currency},
    } = props;

    const period = useMemo(() => {
        let text = '';

        if (
            starts_at &&
            [
                IHotelPenaltyTypes.FULL_PRICE,
                IHotelPenaltyTypes.SOME_PENALTY,
            ].includes(type)
        ) {
            text += `С ${getHumanMoscowFormat(starts_at)}`;
        }

        if (
            ends_at &&
            [
                IHotelPenaltyTypes.NO_PENALTY,
                IHotelPenaltyTypes.SOME_PENALTY,
            ].includes(type)
        ) {
            text += `${text ? ' до' : 'До'} ${getHumanMoscowFormat(ends_at)} `;
        }

        return text;
    }, [type, starts_at, ends_at]);

    const typeText = useMemo(() => {
        switch (type) {
            case IHotelPenaltyTypes.NO_PENALTY: {
                return 'бесплатная отмена';
            }

            case IHotelPenaltyTypes.SOME_PENALTY: {
                return 'штраф';
            }

            case IHotelPenaltyTypes.FULL_PRICE: {
                return 'стоимость не возвращается';
            }
        }
    }, [type]);

    return (
        <div className={b()}>
            <div>
                {period} {typeText}{' '}
                {amount && currency && `${amount} ${currency}`}
            </div>
        </div>
    );
};

export default HotelCancellationInfoPenalty;
