import React, {MutableRefObject} from 'react';
import ReactDatePicker, {DatePickerProps} from 'react-date-picker';
import {block} from 'bem-cn';

import CalendarIcon from 'components/basic/icons/CalendarIcon';

import './index.scss';

const b = block('DatePicker');

interface IOwnProps extends DatePickerProps {
    innerRef: MutableRefObject<HTMLDivElement | null>;
}

const DatePicker: React.FC<IOwnProps> = props => {
    const {innerRef, ...datePickerProps} = props;
    const getCalendarIcon = () => <CalendarIcon />;

    return (
        <div className={b()} ref={innerRef}>
            <ReactDatePicker
                clearIcon={null}
                calendarIcon={getCalendarIcon()}
                {...datePickerProps}
            />
        </div>
    );
};

export default DatePicker;
