import React from 'react';
import {block} from 'bem-cn';

import {IHotelOrderGuest} from 'redux/reducers/types/hotel';

import Heading from 'components/basic/Heading/Heading';
import OrderGetPersonalInfo from 'components/Order/OrderGetPersonalInfo/OrderGetPersonalInfo';
import HotelGuests from 'components/Order/HotelGuestsInfo/HotelGuests/HotelGuests';

const b = block('HotelGuestsInfo');

interface IOwnProps {
    orderId: string;
    adminActionToken: string;
    guests?: IHotelOrderGuest[];
    className?: string;
}

const HotelGuestsInfo: React.FC<IOwnProps> = props => {
    const {orderId, adminActionToken, guests, className} = props;

    const content = guests ? (
        <HotelGuests
            orderId={orderId}
            adminActionToken={adminActionToken}
            guests={guests}
        />
    ) : (
        <OrderGetPersonalInfo />
    );

    return (
        <div className={b.mix(className)}>
            <Heading level="4">Гости</Heading>

            {content}
        </div>
    );
};

export default HotelGuestsInfo;
