import React, {useCallback, useState} from 'react';
import {useSelector} from 'react-redux';
import {block} from 'bem-cn';

import {IStore} from 'redux/reducers/types';

import Heading from 'components/basic/Heading/Heading';
import CalculatedHotelMoneyOnlyRefund from 'components/Order/HotelMoneyOnlyRefund/CalculatedHotelMoneyOnlyRefund/CalculatedHotelOrderRefund';
import HotelMoneyOnlyRefundForm from 'components/Order/HotelMoneyOnlyRefund/HotelMoneyOnlyRefundForm/HotelMoneyOnlyRefundForm';
import DefaultButton from 'components/lego/DefaultButton/DefaultButton';

import './index.scss';

const b = block('HotelMoneyOnlyRefund');

interface IOwnProps {
    className?: string;
    orderId: string;
    adminActionToken: string;
}

const HotelMoneyOnlyRefund: React.FC<IOwnProps> = props => {
    const {className, orderId, adminActionToken} = props;

    const [isCalculatedRefundVisible, setCalculatedRefundVisible] =
        useState(false);

    const handleCalculateRefund = useCallback(() => {
        setCalculatedRefundVisible(true);
    }, []);

    const {isFetched, calculatedRefund} = useSelector(
        (state: IStore) => state.order.calculateHotelMoneyOnlyRefund,
    );

    const content = isCalculatedRefundVisible ? (
        <CalculatedHotelMoneyOnlyRefund
            orderId={orderId}
            adminActionToken={adminActionToken}
        />
    ) : (
        <DefaultButton onClick={handleCalculateRefund}>
            Оформить возврат денежных средств
        </DefaultButton>
    );

    return (
        <div className={b.mix(className)}>
            <Heading level="4">Возврат денежных средств</Heading>

            {content}

            {isFetched && calculatedRefund !== null && (
                <HotelMoneyOnlyRefundForm
                    orderId={orderId}
                    adminActionToken={adminActionToken}
                    calculatedRefund={calculatedRefund}
                />
            )}
        </div>
    );
};

export default HotelMoneyOnlyRefund;
