import React, {useEffect, useMemo} from 'react';
import {useDispatch, useSelector} from 'react-redux';
import {block} from 'bem-cn';
import {Loader} from '@yandex-data-ui/common';
import {calculateHotelOrderRefundRequest} from 'redux/reducers/order/actions';
import {useToasts} from 'react-toast-notifications';

import {IStore} from 'redux/reducers/types';

const b = block('CalculatedHotelOrderRefund');

interface IOwnProps {
    orderId: string;
    adminActionToken: string;
}

const CalculatedHotelOrderRefund: React.FC<IOwnProps> = props => {
    const {orderId} = props;
    const dispatch = useDispatch();
    const {addToast} = useToasts();

    const {isLoading, isFetched, error} = useSelector(
        (state: IStore) => state.order.calculateHotelOrderRefund,
    );

    useEffect(() => {
        if (!orderId) {
            return;
        }

        dispatch(calculateHotelOrderRefundRequest({orderId, addToast}));
    }, [dispatch, orderId, addToast]);

    const content = useMemo(() => {
        if (!isLoading && !isFetched) {
            return null;
        }

        if (isLoading) {
            return (
                <div className={b('loader-wrapper')}>
                    <Loader size="m" />
                </div>
            );
        }

        if (error) {
            return <div className="text-danger">Ошибка расчета возврата</div>;
        }

        return null;
    }, [isLoading, isFetched, error]);

    return <div className={b()}>{content}</div>;
};

export default CalculatedHotelOrderRefund;
