import React, {useCallback, useState} from 'react';
import {useSelector} from 'react-redux';
import {block} from 'bem-cn';

import {IStore} from 'redux/reducers/types';

import Heading from 'components/basic/Heading/Heading';
import DefaultButton from 'components/lego/DefaultButton/DefaultButton';
import CalculatedHotelOrderRefund from 'components/Order/HotelOrderRefund/CalculatedHotelOrderRefund/CalculatedHotelOrderRefund';
import HotelOrderRefundForm from 'components/Order/HotelOrderRefund/HotelOrderRefundForm/HotelOrderRefundForm';

import './index.scss';

const b = block('HotelOrderRefund');

interface IHotelOrderRefundProps {
    className?: string;
    orderId: string;
    adminActionToken: string;
}

const HotelOrderRefund: React.FC<IHotelOrderRefundProps> = props => {
    const {className, orderId, adminActionToken} = props;

    const [isCalculatedRefundVisible, setCalculatedRefundVisible] =
        useState(false);

    const handleCalculateRefund = useCallback(() => {
        setCalculatedRefundVisible(true);
    }, []);

    const {isFetched, calculatedRefund} = useSelector(
        (state: IStore) => state.order.calculateHotelOrderRefund,
    );

    const content = isCalculatedRefundVisible ? (
        <CalculatedHotelOrderRefund
            orderId={orderId}
            adminActionToken={adminActionToken}
        />
    ) : (
        <DefaultButton onClick={handleCalculateRefund}>
            Оформить отмену заказа
        </DefaultButton>
    );

    return (
        <div className={b.mix(className)}>
            <Heading level="4" className={b('RefundTitle')}>
                Отмена заказа
            </Heading>

            {content}

            {isFetched && calculatedRefund !== null && (
                <HotelOrderRefundForm
                    orderId={orderId}
                    adminActionToken={adminActionToken}
                    calculatedRefund={calculatedRefund}
                />
            )}
        </div>
    );
};

export default HotelOrderRefund;
