import React, {useMemo} from 'react';
import {block} from 'bem-cn';

import {AuthorizedUserRoles, IAuthorizedUser} from 'redux/reducers/types';

import Heading from 'components/basic/Heading/Heading';

const b = block('OrderAccess');

interface IOwnProps {
    className?: string;
    authorizedUsers: IAuthorizedUser[];
}

function get_user_login_text(user?: IAuthorizedUser): string {
    if (!user) {
        return 'нет';
    }
    if (user.login) {
        return `залогин, логин: ${user.login}`;
    }
    if (user.is_logged_in) {
        return `залогин, yandexUid: ${user.yandex_uid}`;
    }
    return `незалогин, yandexUid: ${user.yandex_uid}`;
}

const OrderAccess: React.FC<IOwnProps> = props => {
    const {authorizedUsers, className} = props;

    const viewers = authorizedUsers.filter(
        ({role}) => role === AuthorizedUserRoles.VIEWER,
    );

    const ownerText = useMemo(() => {
        const owner = authorizedUsers.find(
            ({role}) => role === AuthorizedUserRoles.OWNER,
        );
        return get_user_login_text(owner);
    }, [authorizedUsers]);

    return (
        <div className={b.mix(className)}>
            <Heading level="4">Доступ в личном кабинете</Heading>

            <div>Создатель: {ownerText}</div>
            <div>
                Читатели:{' '}
                {viewers.length
                    ? viewers
                          .map((viewer: IAuthorizedUser) => {
                              return get_user_login_text(viewer);
                          })
                          .join(', ')
                    : 'нет'}
            </div>
        </div>
    );
};

export default OrderAccess;
