import React from 'react';
import {block} from 'bem-cn';

import {IOrderInfo} from 'redux/reducers/types';

import Heading from 'components/basic/Heading/Heading';
import RestoreDolphinOrderAction from 'components/Order/OrderAdminActions/RestoreDolphinOrderAction/RestoreDolphinOrderAction';
import RegenerateVouchersAction from 'components/Order/OrderAdminActions/RegenerateVouchersAction/RegenerateVouchersAction';

const b = block('OrderAdminActions');

interface IOrderAdminActionsProps {
    className?: string;
    order: IOrderInfo;
}

const OrderAdminActions: React.FC<IOrderAdminActionsProps> = props => {
    const {
        className,
        order: {
            flags: {can_restore_dolphin_order, can_regenerate_vouchers},
        },
    } = props;

    const anyAdminActionEnabled =
        can_restore_dolphin_order || can_regenerate_vouchers;

    if (!anyAdminActionEnabled) {
        return null;
    }

    return (
        <div className={b.mix(className)}>
            <Heading level="4">Инструменты администратора</Heading>

            {can_restore_dolphin_order && (
                <RestoreDolphinOrderAction order={props.order} />
            )}

            {can_regenerate_vouchers && (
                <RegenerateVouchersAction order={props.order} />
            )}
        </div>
    );
};

export default OrderAdminActions;
