import React, {useCallback} from 'react';
import {useDispatch, useSelector} from 'react-redux';
import {Loader} from '@yandex-data-ui/common';
import {useToasts} from 'react-toast-notifications';
import {block} from 'bem-cn';
import {regenerateVouchersRequest} from 'redux/reducers/order/actions';

import {IOrderInfo, IStore} from 'redux/reducers/types';

import './index.scss';

import ActionButton from 'components/lego/ActionButton/ActionButton';

const b = block('RegenerateVouchersAction');

interface RegenerateVouchersActionProps {
    order: IOrderInfo;
}

const RegenerateVouchersAction: React.FC<
    RegenerateVouchersActionProps
> = props => {
    const {
        order: {id: orderId},
    } = props;

    const {
        order: {
            regenerateVouchers: {isLoading},
        },
    } = useSelector((store: IStore) => store);

    const dispatch = useDispatch();

    const {addToast} = useToasts();

    const handleRegenerateVouchersClick = useCallback(() => {
        dispatch(
            regenerateVouchersRequest({
                orderId,
                addToast,
            }),
        );
    }, [orderId, dispatch, addToast]);

    return (
        <div className={b()}>
            Ваучеры:
            {isLoading ? (
                <Loader size="m" className={b('loader').toString()} />
            ) : (
                <ActionButton
                    className={b('button').toString()}
                    type="submit"
                    onClick={handleRegenerateVouchersClick}
                >
                    Перегенерировать
                </ActionButton>
            )}
        </div>
    );
};

export default RegenerateVouchersAction;
