import React, {useCallback} from 'react';
import {useDispatch, useSelector} from 'react-redux';
import {Loader} from '@yandex-data-ui/common';
import {useToasts} from 'react-toast-notifications';
import {block} from 'bem-cn';
import {restoreDolphinOrderRequest} from 'redux/reducers/order/actions';

import {IOrderInfo, IStore} from 'redux/reducers/types';

import './index.scss';
import ActionButton from 'components/lego/ActionButton/ActionButton';

const b = block('RestoreDolphinOrderAction');

interface IRestoreDolphinOrderActionProps {
    order: IOrderInfo;
}

const RestoreDolphinOrderAction: React.FC<
    IRestoreDolphinOrderActionProps
> = props => {
    const {
        order: {id: orderId},
    } = props;

    const {
        order: {
            restoreDolphinOrder: {isLoading},
        },
    } = useSelector((store: IStore) => store);

    const dispatch = useDispatch();

    const {addToast} = useToasts();

    const handleRestoreClick = useCallback(() => {
        dispatch(
            restoreDolphinOrderRequest({
                orderId,
                cancel: false,
                addToast,
            }),
        );
    }, [orderId, dispatch, addToast]);

    const handleRestoreAndCancelClick = useCallback(() => {
        dispatch(
            restoreDolphinOrderRequest({
                orderId,
                cancel: true,
                addToast,
            }),
        );
    }, [orderId, dispatch, addToast]);

    return (
        <div className={b()}>
            Заказ переведён в ручную обработку:
            {isLoading ? (
                <Loader size="m" className={b('loader').toString()} />
            ) : (
                <>
                    <ActionButton
                        className={b('button').toString()}
                        onClick={handleRestoreClick}
                    >
                        Восстановить
                    </ActionButton>

                    <ActionButton
                        className={b('button').toString()}
                        type="submit"
                        onClick={handleRestoreAndCancelClick}
                    >
                        Принудительно отменить
                    </ActionButton>
                </>
            )}
        </div>
    );
};

export default RestoreDolphinOrderAction;
