import React from 'react';
import {block} from 'bem-cn';

import {IBusOrderItem} from 'redux/reducers/types/bus';

import getHumanFormatWithTimeAndTimeZone from 'lib/time/getHumanFormatWithTimeAndTimeZone';

import Heading from 'components/basic/Heading/Heading';

const b = block('OrderBusInfo');

interface IOrderBusInfoProps {
    className?: string;
    busOrderItem: IBusOrderItem;
    hasMaskedInfo: boolean;
}

const OrderBusInfo: React.FC<IOrderBusInfoProps> = props => {
    const {
        className,
        busOrderItem: {
            offer_id,
            ride: {
                ride_id,
                departure_time,
                departure_time_zone,
                arrival_time,
                arrival_time_zone,
                route_name,
                refund_conditions,
            },
        },
    } = props;

    return (
        <div className={b.mix(className)}>
            <Heading level="4">Автобус</Heading>

            <div>
                🚌 {route_name}
                <br />
                <span title="Время местное">
                    Отправление:{' '}
                    {getHumanFormatWithTimeAndTimeZone(departure_time, 'UTC')} (
                    {departure_time_zone})
                </span>
                <br />
                <span title="Время местное">
                    Прибытие:{' '}
                    {getHumanFormatWithTimeAndTimeZone(arrival_time, 'UTC')} (
                    {arrival_time_zone})
                </span>
                <br />
                <span>Условия возврата: {refund_conditions}</span>
                <br />
                Offer id: {offer_id}
                <br />
                Ride id: {ride_id}
            </div>
        </div>
    );
};

export default OrderBusInfo;
