import React from 'react';
import {block} from 'bem-cn';

import {IOrderInfo} from 'redux/reducers/types';

import Heading from 'components/basic/Heading/Heading';
import OrderContactsEmail from 'components/Order/OrderContacts/OrderContactsEmail/OrderContactsEmail';
import OrderContactsPhone from 'components/Order/OrderContacts/OrderContactsPhone/OrderContactsPhone';

const b = block('OrderContacts');

interface IOrderContactsProps {
    className?: string;
    order: IOrderInfo;
}

const OrderContacts: React.FC<IOrderContactsProps> = props => {
    const {order, className} = props;

    return (
        <div className={b.mix(className)}>
            <Heading level="4">Контактные данные</Heading>

            <OrderContactsEmail order={order} />

            <OrderContactsPhone order={order} />
        </div>
    );
};

export default OrderContacts;
