import React, {useMemo} from 'react';
import {block} from 'bem-cn';

import {IOrderPriceInfo} from 'redux/reducers/types';

import Heading from 'components/basic/Heading/Heading';

import './index.scss';

const b = block('OrderCostInfo');

interface IOrderCostInfoProps {
    className?: string;
    orderPriceInfo: IOrderPriceInfo;
}

const OrderCostInfo: React.FC<IOrderCostInfoProps> = props => {
    const {className, orderPriceInfo} = props;

    const promoCodeApplicationsInfo = useMemo(() => {
        if (orderPriceInfo.promo_code_application_results.length == 0) {
            return null;
        }

        return (
            <div className={b('table')}>
                <div className={b('row', {head: true})}>
                    <div className={b('cell')}>Промокод</div>
                    <div className={b('cell')}>Результат применения</div>
                    <div className={b('cell')}>Сумма скидки</div>
                </div>
                {orderPriceInfo.promo_code_application_results.map(
                    promoCodeApplicationInfo => {
                        const {code, type, discount_amount, promo_code_id} =
                            promoCodeApplicationInfo;

                        return (
                            <div key={promo_code_id} className={b('row')}>
                                <div className={b('cell')}>{code}</div>
                                <div className={b('cell')}>{type}</div>
                                <div className={b('cell')}>
                                    {`${discount_amount?.value ?? ''} ${
                                        discount_amount?.currency ?? ''
                                    }`}
                                </div>
                            </div>
                        );
                    },
                )}
            </div>
        );
    }, [orderPriceInfo]);

    const priceInfo = useMemo(() => {
        if (orderPriceInfo) {
            return (
                <>
                    <div>
                        Цена:{' '}
                        {`${orderPriceInfo.price.value} ${orderPriceInfo.price.currency}`}
                    </div>
                    <div>
                        Цена без учета скидки:{' '}
                        {`${orderPriceInfo.original_price.value} ${orderPriceInfo.original_price.currency}`}
                    </div>
                    <div>
                        Скидка:{' '}
                        {`${orderPriceInfo.discount_amount.value} ${orderPriceInfo.discount_amount.currency}`}
                    </div>
                    {promoCodeApplicationsInfo}
                </>
            );
        }

        return null;
    }, [orderPriceInfo]);

    return (
        <div className={b.mix(className)}>
            <Heading level="4">Стоимость с расшифровкой</Heading>
            {priceInfo}
        </div>
    );
};

export default OrderCostInfo;
