import React from 'react';
import {block} from 'bem-cn';

import './index.scss';
import {EPaymentScheduleState, IPaymentSchedule} from 'redux/reducers/types';

import getHumanMoscowFormat from 'lib/time/getHumanMoscowFormat';

import Heading from 'components/basic/Heading/Heading';
import OrderReceipts from 'components/Order/OrderReceipts/OrderReceipts';

const b = block('OrderDeferredPayment');

interface IOwnProps {
    className?: string;
    paymentSchedule?: IPaymentSchedule | null;
}

const OrderDeferredPayment: React.FC<IOwnProps> = props => {
    const {className, paymentSchedule} = props;

    if (!paymentSchedule) {
        return null;
    }

    const {
        initial_invoice: {total_amount, payment_attempts},
        items,
    } = paymentSchedule;

    return (
        <div className={b.mix(className)}>
            <Heading level="4">Рассрочки</Heading>
            <Heading level="6">Предоплата</Heading>
            <div className={b('prepay')}>
                <div>
                    Предоплачено: {total_amount.value} {total_amount.currency}
                </div>
                {payment_attempts &&
                    payment_attempts.map(({receipts}, index) => (
                        <OrderReceipts key={index} receipts={receipts} />
                    ))}
            </div>
            {items && Boolean(items.length) && (
                <div>
                    <Heading level="6">Доплата</Heading>
                    {items.map(
                        ({id, payment_ends_at, penalty_if_unpaid, invoice}) => {
                            const isFullyPaid =
                                invoice.state ===
                                EPaymentScheduleState.PS_FULLY_PAID;

                            return (
                                <div key={id} className={b('postpayItem')}>
                                    <div>
                                        {isFullyPaid ? 'Доплачено' : 'Доплата'}:{' '}
                                        {invoice.total_amount.value}{' '}
                                        {invoice.total_amount.currency}
                                    </div>
                                    {!isFullyPaid && (
                                        <>
                                            <div>
                                                Доплатить до:{' '}
                                                {getHumanMoscowFormat(
                                                    payment_ends_at,
                                                )}
                                            </div>
                                            <div>
                                                Штраф, если вовремя не
                                                доплатить:{' '}
                                                {penalty_if_unpaid.value}{' '}
                                                {penalty_if_unpaid.currency}
                                            </div>
                                        </>
                                    )}
                                    {invoice.payment_attempts &&
                                        invoice.payment_attempts.map(
                                            ({receipts}, index) => (
                                                <OrderReceipts
                                                    key={index}
                                                    receipts={receipts}
                                                />
                                            ),
                                        )}
                                </div>
                            );
                        },
                    )}
                </div>
            )}
        </div>
    );
};

export default OrderDeferredPayment;
