import React from 'react';
import {useSelector, useDispatch} from 'react-redux';
import {orderRequest} from 'redux/reducers/order/actions';

import {IStore} from 'redux/reducers/types';

import DefaultButton from 'components/lego/DefaultButton/DefaultButton';
import ActionButton from 'components/lego/ActionButton/ActionButton';

interface IOrderGetPersonalInfoProps {
    className?: string;
    theme?: 'action' | 'default';
}

const OrderGetPersonalInfo: React.FC<IOrderGetPersonalInfoProps> = props => {
    const {className, theme = 'default'} = props;

    const {
        order: {
            item: {value: order},
        },
    } = useSelector((store: IStore) => store);

    const dispatch = useDispatch();

    if (!order?.flags.has_masked_info) {
        return null;
    }

    const ButtonComponent = theme === 'default' ? DefaultButton : ActionButton;

    return (
        <ButtonComponent
            className={className}
            type="submit"
            onClick={() =>
                dispatch(
                    orderRequest({
                        orderId: order.id,
                        needToFetchPersonalData: true,
                    }),
                )
            }
        >
            Получить персональные данные
        </ButtonComponent>
    );
};

export default OrderGetPersonalInfo;
