import moment from 'moment-timezone';
import {stringify} from 'query-string';

import {Environment} from 'shared/types';
import {IOrderInfo} from 'redux/reducers/types';

export function ytLogsLink(
    env: Environment,
    orderId: string,
    order: IOrderInfo | null,
) {
    let log_start_date = '2021-01-25';
    let log_stop_date = '3000-02-26';

    if (order) {
        log_start_date = moment(order.created_at)
            .tz('Europe/Moscow')
            .format('YYYY-MM-DD');
        log_stop_date = moment(order.updated_at)
            .tz('Europe/Moscow')
            .format('YYYY-MM-DD');
    }

    const ydb_log_copy_for_env =
        env == Environment.production
            ? 'travel-prod-orders-ydb-log-copy'
            : 'travel-test-orders-ydb-log-copy';
    const select_query = `USE \`arnold\`;
    SELECT * FROM
    -- Попробуйте поменять даты в RANGE, чтобы сузить диапазон поиска и ускорить получение логов
    RANGE(\`home/logfeller/logs/${ydb_log_copy_for_env}/1d\`, \`${log_start_date}\`, \`${log_stop_date}\`)
    WHERE \`OwnerId\` = '${orderId}'
    ORDER BY \`timestamp\` DESC
    -- Если не хватает логов, попробуйте убрать лимит или использовать OFFSET
    -- https://yql.yandex-team.ru/docs/yt/syntax/select#limit-offset
    LIMIT 100;
    `;

    return `https://yql.yandex-team.ru/?${stringify({query: select_query})}`;
}
