import {ORDER_LOGS_FILTER_PARAMS} from 'components/Order/OrderLogs/OrderLogsFilters/helpers/constants';

import {IOrderLogsFilterQueryParams} from 'lib/url/types';

import {IOrderLogsFilterFormState} from 'components/Order/OrderLogs/OrderLogsFilters/OrderLogsFilters';

export default function getOrderLogsQueryParamsFromState(
    state: IOrderLogsFilterFormState,
): IOrderLogsFilterQueryParams {
    return ORDER_LOGS_FILTER_PARAMS.reduce(
        (
            searchQuery: IOrderLogsFilterQueryParams,
            searchParam: keyof IOrderLogsFilterQueryParams,
        ): IOrderLogsFilterQueryParams => ({
            ...searchQuery,
            ...(state[searchParam]
                ? {[searchParam]: String(state[searchParam]).trim()}
                : {}),
        }),
        {},
    );
}
