import {IOrderLogsQueryParams} from 'lib/url/types';
import {isOrderLogLevel, OrderLogLevel} from 'redux/reducers/types';

import {IOrderLogsFilterFormState} from 'components/Order/OrderLogs/OrderLogsFilters/OrderLogsFilters';

export default function getRecoveredOrderLogsStateFromQuery(
    filterQueryParams: IOrderLogsQueryParams,
): IOrderLogsFilterFormState {
    const {level, logger, message} = filterQueryParams;

    return {
        level: isOrderLogLevel(level) ? level : OrderLogLevel.IRRELEVANT,
        logger: logger || '',
        message: message || '',
    };
}
