import React from 'react';
import {block} from 'bem-cn';

import {EMirEligibility, IMirPromo} from 'redux/reducers/types';

import Heading from 'components/basic/Heading/Heading';

interface IMirPromosProps {
    className?: string;
    promo: IMirPromo;
    isPostPay: boolean;
}

const b = block('OrderMirPromo');

function getDescription(
    offer_eligibility: EMirEligibility,
    paid_with_mir: boolean | null,
    amount: number | null,
    isPostPay: boolean,
): string {
    if (isPostPay) {
        return 'Заказ не участвует в акции: оплачен на стойке отеля.';
    }

    if (offer_eligibility === EMirEligibility.MIR_PROMO_DISABLED) {
        return 'Заказ не участвует в акции: создан до начала или после окончания акции.';
    }

    if (offer_eligibility === EMirEligibility.MIR_BLACKLISTED) {
        return 'Заказ не участвует в акции: не поддерживаемый отель.';
    }

    if (offer_eligibility === EMirEligibility.MIR_WRONG_LOS) {
        return 'Заказ не участвует в акции: недостаточная длительность проживания.';
    }

    if (offer_eligibility === EMirEligibility.MIR_WRONG_STAY_DATES) {
        return 'Заказ не участвует в акции: выезд слишком поздно.';
    }

    if (offer_eligibility === EMirEligibility.MIR_ELIGIBILE) {
        if (!paid_with_mir) {
            return 'Заказ не участвует в акции: оплачен не той картой.';
        }

        return `Заказ участвует в акции: будет зачислен кешбек ${amount} рублей.`;
    }

    return '';
}

const OrderMirPromo: React.FC<IMirPromosProps> = props => {
    const {
        className,
        promo: {offer_eligibility, paid_with_mir, cashback_amount},
        isPostPay,
    } = props;

    return (
        <div className={b.mix(className)}>
            <Heading level="4">Акция МИР</Heading>

            <div>
                {getDescription(
                    offer_eligibility,
                    paid_with_mir,
                    cashback_amount,
                    isPostPay,
                )}
            </div>
        </div>
    );
};

export default React.memo(OrderMirPromo);
