import React from 'react';
import {block} from 'bem-cn';
import {useSelector, useDispatch} from 'react-redux';
import {Loader} from '@yandex-data-ui/common';
import {useToasts} from 'react-toast-notifications';
import {orderUpdateTrainTicketsRequest} from 'redux/reducers/order/actions';

import {DisplayOrderType, IStore} from 'redux/reducers/types';

import ActionButton from 'components/lego/ActionButton/ActionButton';

import './index.scss';

interface IOrderUpdateTrainTicketsProps {
    className?: string;
}

const b = block('OrderUpdateTrainTickets');

const OrderUpdateTrainTickets: React.FC<
    IOrderUpdateTrainTicketsProps
> = props => {
    const {className} = props;

    const {
        order: {
            item: {value: order},
            updatingTrainTickets: {isLoading: updatingTrainTicketsIsLoading},
        },
    } = useSelector((store: IStore) => store);

    const dispatch = useDispatch();

    const {addToast} = useToasts();

    if (order?.display_order_type !== DisplayOrderType.DT_TRAIN) {
        return null;
    }

    return (
        <div className={b.mix(className)}>
            {updatingTrainTicketsIsLoading ? (
                <Loader size="m" className={b('loader').toString()} />
            ) : (
                <ActionButton
                    type="submit"
                    onClick={() =>
                        dispatch(
                            orderUpdateTrainTicketsRequest({
                                orderId: order.id,
                                addToast,
                            }),
                        )
                    }
                >
                    Обновить статус билетов
                </ActionButton>
            )}
        </div>
    );
};

export default OrderUpdateTrainTickets;
