import React from 'react';
import ReactDiffViewer from 'react-diff-viewer';
import {block} from 'bem-cn';

import './index.scss';

interface IOrderPayloadDiffViewerProps {
    oldValue: string;
    newValue: string;
}

const b = block('OrderPayloadDiffViewer');

const OrderPayloadDiffViewer: React.FC<
    IOrderPayloadDiffViewerProps
> = props => {
    const {oldValue, newValue} = props;

    return (
        <div className={b('wrapper')}>
            <ReactDiffViewer
                oldValue={oldValue}
                newValue={newValue}
                splitView={true}
            />
        </div>
    );
};

export default OrderPayloadDiffViewer;
