import React, {useCallback} from 'react';
import AceEditor from 'react-ace';

import 'ace-builds/src-noconflict/mode-json';
import 'ace-builds/src-noconflict/theme-terminal';

interface IAceJsonEditorProps {
    orderId: string;
    payload: object;
    onChange: (editedPayload: object | null) => void;
}

const AceJsonEditor: React.FC<IAceJsonEditorProps> = props => {
    const {orderId, payload, onChange} = props;

    const handleChange = useCallback(
        (editingInfo: string) => {
            const result = JSON.parse(editingInfo);

            onChange(result);
        },
        [onChange],
    );

    return (
        <AceEditor
            mode="json"
            theme="terminal"
            onChange={handleChange}
            name={`editor-${orderId}`}
            editorProps={{$blockScrolling: true}}
            highlightActiveLine={true}
            setOptions={{
                enableBasicAutocompletion: false,
                enableLiveAutocompletion: false,
                enableSnippets: false,
                showLineNumbers: true,
                tabSize: 2,
            }}
            fontSize="14px"
            height="95vh"
            width="100%"
            value={JSON.stringify(payload, null, 4)}
        />
    );
};

export default AceJsonEditor;
