import React from 'react';

import ReactJsonEditor from 'components/Order/OrderPayloads/OrderPayload/OrderPayloadEditor/ReactJsonEditor';
import TextareaJsonEditor from 'components/Order/OrderPayloads/OrderPayload/OrderPayloadEditor/TextareaJsonEditor';
import AceJsonEditor from 'components/Order/OrderPayloads/OrderPayload/OrderPayloadEditor/AceJsonEditor';

export type IEditorType = 'editor' | 'textarea' | 'ace-editor';

export interface IOrderPayloadEditorProps {
    orderId: string;
    payload: object;
    type: IEditorType;
    onChange: (editedPayload: object | null) => void;
    onSave: (editedPayload: object | null) => void;
}

const OrderPayloadEditor: React.FC<IOrderPayloadEditorProps> = props => {
    const {orderId, payload, type, onChange} = props;

    if (type === 'ace-editor') {
        return (
            <AceJsonEditor
                orderId={orderId}
                payload={payload}
                onChange={onChange}
            />
        );
    }

    if (type === 'textarea') {
        return <TextareaJsonEditor payload={payload} onChange={onChange} />;
    }

    return (
        <ReactJsonEditor
            orderId={orderId}
            payload={payload}
            onChange={onChange}
        />
    );
};

export default OrderPayloadEditor;
